/* Antarmuka dengan Sensor RFID - Trainer Internet of Things
 * Project : Baca sidik jari yan
 * Created By Electins.id
 * https://www.electins.id | https://www.instagram.com/electins.id/
 */

// Library Sidik Jari
#include <Adafruit_Fingerprint.h>
// Library LCD 16x2 I2C
#include <Wire.h> 
#include <LiquidCrystal_I2C.h>
// Library Software Serial
#include <SoftwareSerial.h>

// PIN Buzzer terhubung ke PIN D3 NodeMCU
#define BUZZ_PIN  D3

// LCD Objek dengan nama lcd, alamat I2C 0x27, karakter 16x2
LiquidCrystal_I2C lcd(0x27,16,2);

// Koneksi PIN Fingerprint ke PIN NodeMCU
// TX   D5
// RX   D6
// SofwareSerial objek dengan nama FP_Serial
SoftwareSerial FP_Serial(D5, D6);

// Fingerprint Objek dengan nama finger
// dengan koneksi serial FP_Serial
Adafruit_Fingerprint finger = Adafruit_Fingerprint(&FP_Serial);
// Variabel untuk menyimpan ID
int id = 0;
// Variabel untuk nama ID yang tersimpan
String id_name = "IoT KIT";

void setup() {
  // Serial Monitor pada baudrate 115200
  Serial.begin(115200);
  
  // Mengatur BUZZ_PIN sebagai Output
  // Kondisi awal BUZZ_PIN LOW (Buzzer OFF)
  pinMode(BUZZ_PIN, OUTPUT);
  digitalWrite(BUZZ_PIN, LOW);

  // Komunikasi Serial FP dengan baudrate 57600
  finger.begin(57600);
  
  lcd.init();       // Inisialisasi LCD
  lcd.backlight();  // Menyalakan Backlight LCD
  lcd.print("Trainer Kit IoT"); 
  delay(2000);      // Jeda tampilan teks pada LCD
  lcd.clear();      // Membersihkan tampilan LCD

  // Cek koneksi fingerprint
  if(finger.verifyPassword()) {
    lcd.setCursor(0,0); lcd.print("Sensor ditemukan");
    Serial.println("Sensor ditemukan");
    delay(1000);
    lcd.clear();
  }else{
    lcd.setCursor(0,0); lcd.print("Tidak Ada Sensor");
    Serial.println("Tidak Ada Sensor");
    delay(1000);
    lcd.clear();
  }
}

void loop() {
  // Menampilkan teks pada LCD 16x2 I2C
  lcd.setCursor(0,0); lcd.print(" SELAMAT DATANG ");
  lcd.setCursor(0,1); lcd.print(" SCAN JARI ANDA ");

  // Membaca ID yang tersimpan 
  id = getFingerprintIDez();
  delay(50);

  // ID 1 terdaftar menmpilkan teks dan notif buzzer
  // dan jika ID tidak terdaftar
  if(id == 1){
    lcd.clear();
    buzz_match();
    lcd.setCursor(0,0); lcd.print("ID TERDAFTAR    ");
    lcd.setCursor(0,1); lcd.print("Hai, " + id_name);
    delay(2000);
    id = 0; lcd.clear();
  }else{
    buzz_not_match();
    lcd.setCursor(0,0); lcd.print("TIDAK TERDAFTAR!");
    lcd.setCursor(0,1); lcd.print("Silahkan Reg. fp");
    delay(2000);
    id = 0; lcd.clear();
  }
}

// Fungsi untuk mencari ID yang tersimpan
int getFingerprintIDez() {
  int p = -1;

  // Memindai sidik jari
  while (p != FINGERPRINT_OK){
    p = finger.getImage();
    if(p == FINGERPRINT_OK){
      Serial.println("Memindai sidik jari");
      buzz_scan();
      break;
    }
  }

  // Mengonversi sidik jari
  p = finger.image2Tz();
  if(p == FINGERPRINT_OK){
    Serial.println("Konversi sidik jari");
  }else{
    Serial.println("Konversi bermasalah");
    return p;
  }

  // Mencari sidik jari yang cocok
  p = finger.fingerFastSearch();
  if(p == FINGERPRINT_OK){
    Serial.println("Sidik jari ditemukan");
  }else{
    Serial.println("Sidik jari tidak ditemukan");
    return p;
  }

  // Mencetak ID dengan konfidensi pada serial monitor
  // Mengembalikan nilai ID pada finger.fingerID 
  Serial.print("ID Ditemukan #"); 
  Serial.print(finger.fingerID); 
  Serial.print(" dengan konfidensi "); 
  Serial.println(finger.confidence);
  
  return finger.fingerID; 
}

void buzz_scan() {
  for (int x = 0; x < 8 ; x++ ) {
    digitalWrite(BUZZ_PIN, HIGH);
    delay(50);
    digitalWrite(BUZZ_PIN, LOW);
    delay(30);
    }
}

void buzz_match() {
  for (int x = 0; x < 2 ; x++ ) {
    digitalWrite(BUZZ_PIN, HIGH);
    delay(200);
    digitalWrite(BUZZ_PIN, LOW);
    delay(100);
  }
}

void buzz_not_match() {
  digitalWrite(BUZZ_PIN, HIGH);
  delay(1000);
  digitalWrite(BUZZ_PIN, LOW);
  delay(100);
}
